
import galois

def encode_format(mode, masque):
    donnees = ((mode << 3) ^ masque) << 10
    extra = galois.modulo(donnees, 0b10100110111)
    return (donnees + extra) ^ 0b101010000010010

def encode_message(message):
    bits = 0b0100
    octets_message = message.encode('iso-8859-1')
    longueur = len(octets_message)
    if longueur > 17:
        raise ValueError('Le message est trop long')
    bits <<= 8
    bits ^= longueur

    for octet in octets_message:
        bits <<= 8
        bits ^= octet

    bits <<= 4

    for i in range(17 - longueur):
        bits <<= 8
        if i % 2 == 0:
            bits ^= 236
        else:
            bits ^= 17
    
    octets = []
    for i in range(19):
        octets.insert(0, bits & 255)
        bits >>= 8
    
    return octets
