
BLANC = (255, 255, 255)
NOIR = (0, 0, 0)
GRIS = (127, 127, 127)

def placer_module(img, x, y, couleur):
    img.putpixel((x, y), couleur)

def placer_carre(img, x, y, n, couleur):
    for i in range(n):
        for j in range(n):
            placer_module(img, x + i, y + j, couleur)

def placer_positionnement(img, x, y):
    placer_carre(img, x, y, 7, NOIR)
    placer_carre(img, x + 1, y + 1, 5, BLANC)
    placer_carre(img, x + 2, y + 2, 3, NOIR)

def placer_cadencement(img):
    for i in range(5):
        couleur = BLANC if i % 2 == 1 else NOIR
        placer_module(img, 6, 8 + i, couleur)
        placer_module(img, 8 + i, 6, couleur)

def placer_modules_fixes(img):
    placer_carre(img, 0, 0, 8, BLANC)
    placer_carre(img, 13, 0, 8, BLANC)
    placer_carre(img, 0, 13, 8, BLANC)
    placer_positionnement(img, 0, 0)
    placer_positionnement(img, 14, 0)
    placer_positionnement(img, 0, 14)
    placer_cadencement(img)
    placer_module(img, 8, 13, NOIR)

def bit(n, i):
    return (n >> i) & 1

def couleur_module(b):
    if b == 1:
        return NOIR
    return BLANC

def placer_modules_format(img, format_encode):
    for i in range(6):
        placer_module(img, 8, i, couleur_module(bit(format_encode, i)))
    placer_module(img, 8, 7, couleur_module(bit(format_encode, 6)))
    placer_module(img, 8, 8, couleur_module(bit(format_encode, 7)))
    placer_module(img, 7, 8, couleur_module(bit(format_encode, 8)))
    for i in range(6):
        couleur = couleur_module(bit(format_encode, 9 + i))
        placer_module(img, 5 - i, 8, couleur)

    for i in range(8):
        placer_module(img, 20 - i, 8, couleur_module(bit(format_encode, i)))
    for i in range(7):
        placer_module(img, 8, 14 + i, couleur_module(bit(format_encode, 8 + i)))

def applique_masque(x, y, b):
    m = 1 if (x + y) % 3 == 0 else 0
    return b ^ m

def placer_module_donnee(img, x, y, b):
    placer_module(img, x, y, couleur_module(applique_masque(x, y, b)))

def placer_octet_montant(img, octet, x, y):
    for i in range(8):
        dx = i % 2
        dy = i // 2
        placer_module_donnee(img, x + dx, y + dy, bit(octet, i))

def placer_octet_descendant(img, octet, x, y):
    for i in range(8):
        dx = i % 2
        dy = 3 - (i // 2)
        placer_module_donnee(img, x + dx, y + dy, bit(octet, i))

def placer_octet_montant_separe(img, octet, x, y):
    for i in range(8):
        dx = i % 2
        dy = i // 2 + i // 4
        placer_module_donnee(img, x + dx, y + dy, bit(octet, i))

def placer_octet_descendant_separe(img, octet, x, y):
    for i in range(8):
        dx = i % 2
        dy = 4 - (i // 2) - (i // 4)
        placer_module_donnee(img, x + dx, y + dy, bit(octet, i))

def placer_modules_donnees(img, octets):
    for i in range(3):
        placer_octet_montant(img, octets[i], 19, 17 - i * 4)
    for i in range(3):
        placer_octet_descendant(img, octets[3 + i], 17, 9 + i * 4)
    for i in range(3):
        placer_octet_montant(img, octets[6 + i], 15, 17 - i * 4)
    for i in range(3):
        placer_octet_descendant(img, octets[9 + i], 13, 9 + i * 4)
    for i in range(3):
        placer_octet_montant(img, octets[12 + i], 11, 17 - i * 4)
    placer_octet_montant_separe(img, octets[15], 11, 4)
    placer_octet_montant(img, octets[16], 11, 0)
    placer_octet_descendant(img, octets[17], 9, 0)
    placer_octet_descendant_separe(img, octets[18], 9, 4)
    for i in range(3):
        placer_octet_descendant(img, octets[19 + i], 9, 9 + i * 4)
    placer_octet_montant(img, octets[22], 7, 9)
    placer_octet_descendant(img, octets[23], 4, 9)
    placer_octet_montant(img, octets[24], 2, 9)
    placer_octet_descendant(img, octets[25], 0, 9)
